% Model of an isothermal batch reactor - Alkylation

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

tspan = 0:5:330;     % We want output every 5 s up to 500 s
cC40 = 1;            % Initial butene concentration (kmol/m3)
ciC40 = 5;           % Initial isobutane concentration (kmol/m3)
ciC80 = 1.79;        % Initial isooctane concentration (kmol/m3)

k1 = 10.5;           % Rate constant (m3/kg/s)
K = 3840;            % Rate constant (-)
V = 20;              % Reactor volume (m3)
m = 5;               % Catalyst mass (kg)

c0(1) = cC40;         % Running variable for cC4 is C(1)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[T,C] = ode45(@f,tspan,c0,options,cC40,ciC40,k1,K,V,m);

% Output

figure(1)
plot(T,C)
xlabel('Time (s)');
ylabel('Concentration of C4 (kmol/m3)');
T
C
[s1,s2] = size(T);
conversion = (C(1,1)-C(s1,1))/C(1,1)
